package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.ejie.p06b.datatype.model.P06B45T00Datatype;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (26/01/2012)
 */
public class P06B45T00DAO {
	
	static private P06B45T00DAO instance = null;

	public static P06B45T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B45T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B45T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	
	/**
    * Obtiene un registro de la BD a partir de la clave primaria
    * @param numExp.
    *            parte de la clave primaria
    * @param ejer.
    *            parte de la clave primaria
    * @return un objeto P06B45T00Datatype o null si no se encuentra nada.
	* @throws Exception
    */
	public P06B45T00Datatype select(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B45T00DAO-select");
		P06B45T00Datatype result = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	result = new P06B45T00Datatype();
	        	
	        	result.setEjercicio(lrst.getString(P06BTablas.P06B_P06B45_EJERCICIO));
	        	result.setNumExp(lrst.getString(P06BTablas.P06B_P06B45_NUMEXP));
				result.setRegimen(lrst.getString(P06BTablas.P06B_P06B45_REGIMEN)==null?"":lrst.getString(P06BTablas.P06B_P06B45_REGIMEN));
				result.setNumEmplAfec(lrst.getString(P06BTablas.P06B_P06B45_NUMEMPLAFEC)==null?"":lrst.getString(P06BTablas.P06B_P06B45_NUMEMPLAFEC));
				result.setNumEmplNoAfec(lrst.getString(P06BTablas.P06B_P06B45_NUMEMPLNOAFEC)==null?"":lrst.getString(P06BTablas.P06B_P06B45_NUMEMPLNOAFEC));				
	        }
	        P06BLog.send(2,this, "Fin P06B45T00DAO-select");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return result;
	}
	
	
	private static String SELECT_BY_PK =
		"SELECT " +	
		P06BTablas.P06B_P06B45_EJERCICIO + ", " + 
		P06BTablas.P06B_P06B45_NUMEXP + ", " + 
		P06BTablas.P06B_P06B45_REGIMEN + ", " + 
		P06BTablas.P06B_P06B45_NUMEMPLAFEC + ", " + 
		P06BTablas.P06B_P06B45_NUMEMPLNOAFEC +
				
		" FROM "+ P06BTablas.P06B_P06B45T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B45_EJERCICIO + " = ? and " + P06BTablas.P06B_P06B45_NUMEXP + " = ?";
	
	
}
